
# Load packages
library(readxl)
library(dplyr)

# Read Excel file
df <- read_excel("Supplementary Data 2.xlsx", sheet = "Sheet1")

# Select categorical variables
cat_vars <- df %>%
  select(sex,
         hypertension,
         `Coronary heart disease`,
         `heart failure`,
         Arrhythmias,
         `Peripheral vascular disease`,
         diabetes,
         Hyperlipidemia,
         `lung cancer`,
         osteoporosis)

# Convert to factors
cat_vars <- cat_vars %>%
  mutate(across(everything(), ~factor(.x, levels = c(0,1), labels = c("No","Yes"))))

# Check results
str(cat_vars)
